//+------------------------------------------------------------------+
//|                                       Voila Method Indicator.mq4 |
//|                                                              --- |
//|                                                          no link |
//+------------------------------------------------------------------+
#property copyright "---"
#property link      "no link"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Gold
#property indicator_color2 Tomato
//---- buffers
//---- 2 Buffer fr die 2 Linien des Indikators
double ExtMapBuffer1[];
double ExtMapBuffer2[];

//---- Die Anzahl Perioden aus denen die ATR berechnet wird und der Faktor
//---- mit dem dieser "Abstand" multipliziert wird, als externe Variablen
//---- damit man sie im Properties Tab einfach ndern kann
extern int ATR_period = 10;
extern double Factor = 2;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+

//---- Diesen Teil habe ich vom MQL4 Kurs von forex-tsd bernommen
int start()
  {
   int    counted_bars=IndicatorCounted();

//---- check for possible errors
   
   if(counted_bars<0) return(-1);
   
//---- last counted bar will be recounted
   
   if(counted_bars>0) counted_bars--;
   
   int pos=Bars-counted_bars;
   
   double dClose;
   double dTLinePlus;
   double dTLineMinus;
   double dSpace;   
//---- main calculation loop
//---- Die Schleife startet beim letzten schon gezhlten Bar und geht dann bis 0
//---- (dem aktuellen Bar)
while(pos>=0)
{
dClose = Close[pos+1];
dSpace = Factor*iATR(NULL,0,ATR_period,pos);
dTLinePlus = dClose+dSpace;
dTLineMinus = dClose-dSpace; 
ExtMapBuffer1[pos] = dTLinePlus;
ExtMapBuffer2[pos] = dTLineMinus;
pos--;
}

   
   return(0);
  }
//+------------------------------------------------------------------+